


 /**
 ******************************************************************************
 *
 * @file        MG32_USBD_Descriptor_API.c
 * @brief       The USBD Descriptor's c file.
 *
 * @par         Project
 *              MG32
 * @version     V1.00
 * @date        2022/11/22
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#include "MG32_USBD_API.h"
#include "MG32_USBD_Descriptor_API.h"
#include "MG32_USB_Init.h"
#include "MG32_USBD_EasyCOM_API.h"



const uint8_t USB_INTERFACE3_HID_REPORT[] = 
{
	0x06, 0x01, 0xff,                   //Usabe page (Vendor define 0xFF01)
    0x09, 0x01,                         //Usage (1)
    0xa1, 0x01,                         //Collection
    0x95, 0x40,                         //    Report Count (64)
    0x75, 0x08,                         //    Report Size  (8)
    0x15, 0x00,                         //    Logical Minimum 0
    0x26, 0xff, 0x00,                   //    Logical Maximum 0xFF
    0x09, 0x00,                         //    Usage (Unassigned)
    0x81, 0x02,                         //    Input (Data, Variable, Absolute)
    0x09, 0x00,                         //    Usage (Unassigned)
    0x91, 0x02,                         //    Output (Data, Variable, Absolute)
    0x09, 0x01,                         //    Usage (Vendor Usage 1)
    0xb1, 0x02,                         //    Feature(Data , Variable , Absolute , No Wrap , Linear , Preferred State , No Null Position , Non  Volatile , Bit Field)
    0xc0                                //End Collection	  
};


#define INTERFACE3_HID_REPORT_LENGTH    sizeof(USB_INTERFACE3_HID_REPORT)                 /*!< USB interface 3 HID report.*/

const uint16_t Interface3_HID_ReportLength = INTERFACE3_HID_REPORT_LENGTH;

/**
 *************************************************************************************************************
 * @fn       	DEVICE Descriptor  relationship 
 * @param    	No
 * @return      No
 * @details    	//-----------------USB 2.0------------------------------
				0: 		bLength 			Number		Size of this descriptor in bytes
				1: 		bDescriptorType		Constant	DEVICE Descriptor Type
				2,3: 	bcdUSB		    	BCD			USB specification release number in Binary-coded Decimal.
														This field identifies the release of the USB specification with
														which the device and its descriptors are compliant
				4:		bDeviceClass		Class		Class code:
														(1) If this field is reset to zero, each interface within a configuration 
															specifies its own class information and the various inerfaces operate
															independently
														(2) If this field is set to a value between 1 and 0xFE, the device supports 
															different class specifications on different interfaces and the 
															interfaces may not operate independently. This value identifies the 
															class definition used for the aggregate interfaces
														(3) If this field is set to 0xFF, the device class is vendor-specific
				5:    bDeviceSubClass 	Subclass	Subclass code
														(1) These codes are qualified by the value of the bDeviceClass field
														(2) If the bDeviceClass field is reset zero this field must alse be reset
															to zero.
														(3) If the bDeviceClass field is not set to 0xFF, all values are reserved 
															for assignment by the USB-IF.
				6:		bDeviceProtocol		Protocol    Protocol code
														(1) These codes are qualified by the value of the bDeviceSubClass fields.
															and the bDeviceSubClass field.
														(2) If a device supports class-specific protocols on a device basis  as 
															opposed to an interface basis, this code identifies the protocols 
															that the device uses as defined by the specification of the device class.
														(3) If this field is reset to zero, the device does not use class-specific 
															protocols on a device basis. However, it may use class-specific 
															protocols on an interface basis
														(4) If this field is set to 0xFF, the device uses a vendor-specific
															protocol on a device basis.
				7:		bMaxPacketSize0 	Number  	Maximum packet size for endpoint zero(only 8,16,32,or 64 are valid)
				8,9:    idVendor        	ID			VendorID(assigned by the USB-IF)
				10,11:  idProduct       	ID			Product ID(assigned by the manufacturer)
				12,13:  bcdDevice			BCD			Device release number in binary coded decimal
				14:     iManufacturer   	Index		Index of string descriptor describing manufacturer
				15:     iProduct        	Index 		Index of string descriptor describing product
				16:     iSerialNumber   	Index 		Index of string descriptor describing the device's serial number
				17:     bNumConfigurations	Number      Number of possible configurations
 **************************************************************************************************************
 */ 
const uint8_t USB_DEVICE_DESCRIPTOR[]=
{ 
    0x12,                                        // 0:  bLength
    DEVICE_DESCRIPTOR,                           // 1:  bDescriptorType (0x01 = Device)
    LOBYTE( bcdUSB ),                            //     bcdUSB(LSB)
    HIBYTE( bcdUSB ),                            //     bcdUSB(MSB)
    bDeviceClass,                                // 4:  bDeviceClass 
    bDeviceSubClass,                             // 5:  bDevice SubClass
    bDeviceProtocol,                             // 6:  bDeviceProtocol
    MG_USB_EP0_DSIZE,                            // 7:  bMaxPacketSize
    LOBYTE( USB_VID ),                           // 8:  idVendor(LSB)
    HIBYTE( USB_VID ),                           //     idVendor(MSB)
    LOBYTE( USB_PID ),                           // 10: idProduct(LSB)
    HIBYTE( USB_PID ),                           //     idProduct(MSB)
    LOBYTE( USB_DID ),                           // 12: bcdDevice(LSB)
    HIBYTE( USB_DID ),                           //     bcdDevice(MSB)
    
    MF_STRING_INDEX,                             // 14: iManufacture (String Index)
    
    PD_STRING_INDEX,                             // 15: iProduct     (String Index) 
    
    SN_STRING_INDEX,                             // 16: iSerialNumber(String Index)
    
    0x01                                         // 17: bNumConfigurations
};

/**
 ***************************************************************************************************************
 * @fn       	Configuration Descriptor  relationship 
 * @param    	
 * @return      
 * @details    	
 ***************************************************************************************************************
 */ 
const uint8_t USB_CONFIGURATION_DESCRIPTOR[] = 
{ 
    //==========================================================================================
    //Configuration Descriptor
    0x09,                                                  // 0:  bLength
    CONFIGURATION_DESCRIPTOR,                              // 1:  bDescriptorType (0x02 = configuration )
    LOBYTE( USB_CONFIGURATION_DESC_TOTAOSIZE ),            // 2:  wTotalLength(LSB)(All Descriptor ,
    HIBYTE( USB_CONFIGURATION_DESC_TOTAOSIZE ),            // 3:  wTotalLength(MSB)(Exclude "String")
    USB_CONFIGURATION_TOTAOL_INTERFACE,                    // 4:  bNumInterface
    0x01,                                                  // 5:  bConfigurationValue
    0x00,                                                  // 6:  iConfiguration (String Index)
    USB_bmAttributes,                                      // 7:  bmAttributes (Bus power & Remote wakeup)
                                                           //     D7:      Reserved (Set to one)
                                                           //     D6:      Self Powered
                                                           //     D5:      Remote Wakeup
                                                           //     D4..0:   Reserved (Reset to 0)
    (USB_bMaxPower/2),                                     // 8:  Power    (100mA)
    
    //==========================================================================================
    //Interface Association Descriptor Abstract Control Model
    0x08,                                                  // 0:  bLength
    INTERFACE_ASSOCIATION_DESCRIPTOR,                      // 1:  bDescriptorType
    0x00,                                                  // 2:  bFirstInterface
    0x02,                                                  // 3:  bInterfaceCount
    0x02,                                                  // 4:  bFunctionClass
    0x02,                                                  // 5:  bFunctionSubClass
    0x01,                                                  // 6:  bFunctionProtocol 
    0x00,                                                  // 7:  iFunction  
    
    //==========================================================================================
    //Interface Descriptor ( Communication Interface)
    0x09,                                                  // 0:  bLength
    INTERFACE_DESCRIPTOR,                                  // 1:  bDescriptorType
    0x00,                                                  // 2:  bInterfaceNumber
    0x00,                                                  // 3:  bAlternateSetting
    0x01,                                                  // 4:  bNumEndpoints
    bInterfaceClass_CDC,                                   // 5:  bInterfaceClass
    CDC_ABSTRACT_CONTROL_MODEL,                            // 6:  bInterfaceSubClass
    CDC_AT_ITU_T_V_250,                                    // 7:  bInterfaceProtocol
    0x00,                                                  // 8:  iInterface         (String Index)
    
        //=========================================================================================
        //Header Descriptor
        0x05,                                                  // 0:  bLength
        CS_INTERFACE_DESCRIPTOR,                               // 1:  bDescriptorType
        HEADER_FUNCTIONAL_DESCRIPTOR,                          // 2:  bDescriptorSubtype
        0x10,                                                  // 3:  bcdCDC
        0x01,
        
        //=========================================================================================
        //Call Management Descriptor
        0x05,                                                  // 0:  bLength
        CS_INTERFACE_DESCRIPTOR,                               // 1:  bDescriptorType
        CALL_MANAGEMENT_FUNCTIONAL_DESCRIPTOR,                 // 2:  bDescriptorSubtype
        0x01,                                                  // 3:  bmCapabilities
        0x01,                                                  // 4:  bDataInterface
                                                               //     - Indicates that multiplexed commands are handled via data interface 01h
                                                               //       (Same value as used in the UNION Functional Descriptor)
                                                               
        //=========================================================================================
        //Abstract Descriptor
        0x04,                                                  // 0:  bLength
        CS_INTERFACE_DESCRIPTOR,                               // 1:  bDescriptorType
        ABSTRACT_CONTROL_MANAGEMENT_FUNCTIONAL_DESCRIPTOR,     // 2:  bDescriptorSubtype
        0x06,                                                  // 3:  bmCapabilities
        
        //=========================================================================================
        //Union Descriptor
        0x05,                                                  // 0:  bLength
        CS_INTERFACE_DESCRIPTOR,                               // 1:  bDescriptorType
        UNION_FUNCTIONAL_DESCRIPTOR,                           // 2:  bDescriptorSubtype
        0x00,                                                  // 3:  bControlInterface
        0x01,                                                  // 4:  bSubordinateInterface0 (Interface number of the subordinate( Data Class interface)
        

        //==========================================================================================
        //Endpoint Descriptor 
        0x07,           				                       // 0:  bLength
        ENDPOINT_DESCRIPTOR,       		                       // 1:  bDescriptorType
        (USB_EP_IN | USB_EP_3),      	                       // 2:  bEndpointerAddress
                   					                           //      D7:     Direction(0:OUT, 1:IN)
                   					                           //      D6..4:  Reserved (reset to 0)
                    				                           //      D3..0:  Endpoint Number(0000-1111)
        (USB_EP_INTERRUPT | USB_EP_NO_SYNC | USB_EP_DATA),     // 3:  bmAttributes
                    				                           //      D7..2:  Reserved (reset to 0)
                    				                           //      D1..0:  Transfer Type(00:Control,01:Bulk,02:Iso,03:Int)
        LOBYTE(EP3_PACKET_SIZE),       				           // 4:  wPacketSize(LSB)
        HIBYTE(EP3_PACKET_SIZE),       				           //     wPacketSize(MSB)
        0x01,        				                           // 6:  bInterval (Unit 1ms)
                                                               //      Isochronous Endpoint: 01
                                                               //      Interrupt Endpoint: 01-ff 
    
    //==========================================================================================
    //Interface Descriptor ( Data Interface)
    0x09,                                                  // 0:  bLength
    INTERFACE_DESCRIPTOR,                                  // 1:  bDescriptorType
    0x01,                                                  // 2:  bInterfaceNumber
    0x00,                                                  // 3:  bAlternateSetting
    0x02,                                                  // 4:  bNumEndpoints
    bInterfaceClass_CDC_DATA,                              // 5:  bInterfaceClass
    CDC_DATA_USBSPEC,                                      // 6:  bInterfaceSubClass
    0x00,                                                  // 7:  bInterfaceProtocol
    0x00,                                                  // 8:  iInterface         (String Index)
    
        //==========================================================================================
        //Endpoint Descriptor 
        0x07,           				                        // 0:  bLength
        ENDPOINT_DESCRIPTOR,       		                        // 1:  bDescriptorType
        (USB_EP_IN | USB_EP_2),      	                        // 2:  bEndpointerAddress
                   					                            //      D7:     Direction(0:OUT, 1:IN)
                   					                            //      D6..4:  Reserved (reset to 0)
                    				                            //      D3..0:  Endpoint Number(0000-1111)
        (USB_EP_BULK | USB_EP_NO_SYNC | USB_EP_DATA),           // 3:  bmAttributes
                    				                            //      D7..2:  Reserved (reset to 0)
                    				                            //      D1..0:  Transfer Type(00:Control,01:Bulk,02:Iso,03:Int)
        LOBYTE(EP2_PACKET_SIZE),       				            // 4:  wPacketSize(LSB)
        HIBYTE(EP2_PACKET_SIZE),       				            //     wPacketSize(MSB)
        0x00,        				                            // 6:  bInterval (Unit 1ms)
                    				                            //      Isochronous Endpoint: 01
                    				                            //      Interrupt Endpoint: 01-ff 
                                                             
        //==========================================================================================
        //Endpoint Descriptor 
        0x07,           				                        // 0:  bLength
        ENDPOINT_DESCRIPTOR,       		                        // 1:  bDescriptorType
        (USB_EP_OUT | USB_EP_2),      	                        // 2:  bEndpointerAddress
                   					                            //      D7:     Direction(0:OUT, 1:IN)
                   					                            //      D6..4:  Reserved (reset to 0)
                    				                            //      D3..0:  Endpoint Number(0000-1111)
        (USB_EP_BULK | USB_EP_NO_SYNC | USB_EP_DATA),           // 3:  bmAttributes
                    				                            //      D7..2:  Reserved (reset to 0)
                    				                            //      D1..0:  Transfer Type(00:Control,01:Bulk,02:Iso,03:Int)
        LOBYTE(EP2_PACKET_SIZE),       				            // 4:  wPacketSize(LSB)
        HIBYTE(EP2_PACKET_SIZE),       				            //     wPacketSize(MSB)
        0x00,        				                            // 6:  bInterval (Unit 1ms)
                                                                //      Isochronous Endpoint: 01
                                                                //      Interrupt Endpoint: 01-ff                                                                 
    //=================================================================================
    // Interface 2 Descriptor ( HID )                                                             
    0x09,                                        // 0:  bLength
    INTERFACE_DESCRIPTOR,                        // 1:  bDescriptorType ( 0x04 = Interface) 
    0x02,                                        // 2:  bInterfaceNumber
    0x00,                                        // 3:  bAlternateSetting
    0x02,                                        // 4:  bNumEndpoints
    bInterfaceClass_HID,                         // 5:  bInterfaceClass
    0x00,                                        // 6:  bInterfaceSubClass
    0x00,                                        // 7:  bInterfaceProtocol
    0x00,                                        // 8:  iInterface         (String Index)                 
    
        //=================================================================================
        // HID Descriptor
        0x09,                                        // 0:  bLength
        HID_DESCRIPTOR,                              // 1:  bDescriptorType
        0x11,                                        // 2:  bcdHIDClassL
        0x01,                                        // 3:  bcdHIDClassH
        0x00,                                        // 4:  Hardware Target Country
        0x01,                                        // 5:  Number of HID class descriptor to follow
        0x22,                                        // 6:  Report descriptor type
        LOBYTE( INTERFACE3_HID_REPORT_LENGTH ),      // 7:  Total length of Report descriptor L
        HIBYTE( INTERFACE3_HID_REPORT_LENGTH ),      // 8:  Total length of Report descriptor H  

        //=================================================================================
        // Endpoint Descriptor
        0x07,           				                     // 0:  bLength
        ENDPOINT_DESCRIPTOR,       		                     // 1:  bDescriptorType
        (USB_EP_IN | USB_EP_1),      	                     // 2:  bEndpointerAddress
                   					                         //      D7:     Direction(0:OUT, 1:IN)
                   					                         //      D6..4:  Reserved (reset to 0)
                    				                         //      D3..0:  Endpoint Number(0000-1111)
        (USB_EP_INTERRUPT | USB_EP_NO_SYNC | USB_EP_DATA),   // 3:  bmAttributes
                    				                         //      D7..2:  Reserved (reset to 0)
                    				                         //      D1..0:  Transfer Type(00:Control,01:Bulk,02:Iso,03:Int)
        LOBYTE(EP1_PACKET_SIZE),       				         // 4:  wPacketSize(LSB)
        HIBYTE(EP1_PACKET_SIZE),       				         //     wPacketSize(MSB)
        0x01,                           				     // 6:  bInterval (Unit 1ms)
                    				                         //      Isochronous Endpoint: 01
                    				                         //      Interrupt Endpoint: 01-ff 
                                                             
        //=================================================================================
        // Endpoint Descriptor
        0x07,           				                     // 0:  bLength
        ENDPOINT_DESCRIPTOR,       		                     // 1:  bDescriptorType
        (USB_EP_OUT | USB_EP_1),      	                     // 2:  bEndpointerAddress
                   					                         //      D7:     Direction(0:OUT, 1:IN)
                   					                         //      D6..4:  Reserved (reset to 0)
                    				                         //      D3..0:  Endpoint Number(0000-1111)
        (USB_EP_INTERRUPT | USB_EP_NO_SYNC | USB_EP_DATA),   // 3:  bmAttributes
                    				                         //      D7..2:  Reserved (reset to 0)
                    				                         //      D1..0:  Transfer Type(00:Control,01:Bulk,02:Iso,03:Int)
        LOBYTE(EP1_PACKET_SIZE),       				         // 4:  wPacketSize(LSB)
        HIBYTE(EP1_PACKET_SIZE),       				         //     wPacketSize(MSB)
        0x01,                           				     // 6:  bInterval (Unit 1ms)
                    				                         //      Isochronous Endpoint: 01
                    				                         //      Interrupt Endpoint: 01-ff                                                             
};

/**
 ***************************************************************************************************************
 * @fn       	STRING Descriptor  relationship 
 * @param    	
 * @return      
 * @details    	//-----------------USB 2.0------------------------------
				0:		bLength				Number		Size of this descriptor in bytes
				1:		bDescriptorType		Constant	STRING Descriptor Type
				2:		wLANGID[0]          Number      LANGID code zero
				...
				N		wLANGID[N]          Number      LANGID code x
***************************************************************************************************************
 */ 
const uint8_t USB_STRING_DESCRIPTOR[] = 
{
	0x04,										// 0: Computed byte subtraction two from the value of the first byte of the descriptor
	STRING_DESCRIPTOR,							// 1: Descriptor Type
	LOBYTE(LANGUAGEID_ENGLISH_US),              // 2: Supported Language Code Zero.
	HIBYTE(LANGUAGEID_ENGLISH_US),
};


#if MF_STRING == 1

//-----MANUFACTURER(UNICODE) in String Descriptor-----//
const uint8_t Manufacturer_Descriptor[] = 
{
    MANUFACTURER_DESCRIPTOR,
};
#endif
  

#if PD_STRING == 1

//-----PRODUCT(UNICODE) in String Descriptor-----//
const uint8_t Product_Descriptor[] = 
{ 
    PRODUCT_DESCRIPTOR
};
#endif

#if SN_STRING == 1

//-----Serial Number in String Descriptor-----//
const uint8_t SerialNumber_Descriptor[]=
{ 
    SERIALNUMBER_DESCRIPTOR
};
#endif

/**
***************************************************************************************************************
 * @fn       	BOS Descriptor  relationship
 * @param    	
 * @return      
 * @details    	//-----------------USB 3.0------------------------------
				0:		bLength				Number		Size of this descriptor
				1:		bDescriptorType		Constant	Descriptor type: BOS.
				2.3:	wTotalLength        Number      Length of this descriptor and all of its sub descriptors.
				4:		bNumDeviceCaps      Number      The number of separate device capability descritpor in the
                                                        BOS.
 * @Note        Refer to Section 7.4.1 of the Gertified Wireless USB Specification.
***************************************************************************************************************
 */ 
#if MG_USB_LPM_EN == 1
const uint8_t USB_BOS_DESCRIPTOR[]=
{
    0x05,                                        // 0:  bLength
    BOS_DESCRIPTOR,                              // 1:  bDescriptorType ( 0x0F = BOS) 
    0x0C,                                        // 2:  wTotalLength
    0x00,                                        //   
    0x01,                                        // 4:  bNumDeviceCaps
    
};
/**
***************************************************************************************************************
 * @fn       	USB Device Capabilities - USB2.0 Extension Descriptor. (LPM) 
 * @param    	
 * @return      
 * @details    	//-----------------USB 2.0------------------------------
				0:		bLength				Number		Size of this descriptor
				1:		bDescriptorType		Constant	Descriptor type: DEVICE CAPABLITY Type.
				2:	    bInterfaceNumber    Constant    Capability type : USB2.0 EXTENSION (02H)
                31:0:   bAlternateSetting	Bitmap      Bitmap encoding of supported device level features.
                                                        A Value of one in a bit location indicate a feature is 
                                                        supported ; a value of zero indicates it is no supported.
                                                        Encodings are:
                                                        
                                                        Bit      Encoding
                                                        ---      --------
                                                        0        Reserved .Must be set to zero.
                                                        1        LPM. A value of one in this bit location indicates
                                                                 that this device supports the Link Power Management
                                                                 protocol.
                                                        2        BSEL and Alternate HIRD Supported.
                                                        31:3     Reserved.
***************************************************************************************************************
 */ 
const uint8_t USB_EXT_DESCRIPTOR[] = 
{
    0x07,
    DEVICE_CAPABILITY_DESCRIPTOR,                   
    0x02,
    0x06,
    0x00,
    0x00,
    0x00,
};
#endif



